ORCA/M Asm65816 2.1.0

0001 2000              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0002 2000              ;                                                                         ;
0003 2000              ;                          ProDOS boot code                               ;
0004 2000              ;                                                                         ;
0005 2000              ;             Copyright Apple Computer, Inc. 1986-1989,1993               ;
0006 2000              ;                                                                         ;
0007 2000              ;                         All Rights Reserved                             ;
0008 2000              ;                                                                         ;
0009 2000              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0010 2000              ;
0011 2000              ; REVISION HISTORY
0012 2000              ;
0013 2000              ; System 6.0.1
0014 2000              ;
0015 2000              ; 27-Oct-92             Dave Lyons
0016 2000              ;
0017 2000              ; If the user hits the "8" key before we run, then we load and run
0018 2000              ; System/P8 insteasd of System/Start.GS.OS.
0019 2000              ;
0020 2000              ; 6-May-93              Dave Lyons, with Steve Stephenson & Jim Murphy
0021 2000              ;
0022 2000              ; Added CreateRAM5, to compensate for a ROM 3 bug that fails to create
0023 2000              ; RAM5 if you have 8 Megs of RAM.
0024 2000              ;
0025 2000              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0026 2000
0027 2000                       MACHINE M65816
0028 2000                       string asis
0029 2000                       blanks off
0030 2000
0031 2000                       entry startup
0032 2000                       entry readinfile
0033 2000                       entry getbootname
0034 2000                       entry getfstname
0035 2000                       entry dp_start
0036 2000                       entry get_filename
0037 2000                       entry find_file_entry
0038 2000                       entry read_block
0039 2000                       entry getblknum
0040 2000                       entry moveblock
0041 2000                       entry fst_name
0042 2000                       entry start_path
0043 2000                       entry start_p8_path
0044 2000                       entry startup_err
0045 2000                       entry not_a_gs
0046 2000                       entry wrong_rom
0047 2000                       entry wrong_rom2
0048 2000
0049 2000              ;-------------------------------------------------------------------------------
0050 2000              ; equates
0051 2000              ;-------------------------------------------------------------------------------
0052 2000
0053 2000              ; Direct Page Storage
0054 2000
0055 2000              save_d   equ   0                        ;space to save direct register
0056 2000              case_bits equ   2                       ;upper/lower case info for volume name
0057 2000              path_len equ   4                        ;length of partial pathname
0058 2000              path_index equ   6                      ;index into partial pathname
0059 2000              path_ptr equ   8                        ;pointer to partial pathname
0060 2000              buffer_ptr equ   12                     ;pointer to memory buffer
0061 2000              file_eof equ   16                       ;eof of file
0062 2000              indexblkoff equ   18                    ;offset into an index block
0063 2000              num_blks equ   20                       ;number of blocks to read in
0064 2000              entryadr equ   22                       ;address of file entry
0065 2000              entrylen equ   24                       ;length of file entry
0066 2000              entsperblk equ   26                     ;# of file entries per dir block
0067 2000              numentries equ   28                     ;count of # of file entries to check
0068 2000              entsactive equ   30                     ;active entry count
0069 2000              entrieschkd equ   32                    ;# of file entries checked so far
0070 2000              nfilestochk equ   34                    ;total # of file entries to check
0071 2000              header_flag equ   36                    ;non-zero if reading header block
0072 2000              name_len equ   38                       	;length of volume name
0073 2000              lopage   equ   40
0074 2000              hipage   equ   42
0075 2000              filename equ   44                       ;local storage for filename (16 bytes)
0076 2000
0077 2000
0078 2000              ; Stack frame for readinfile
0079 2000
0080 2000              eof_return equ   8
0081 2000              atype_return equ   6
0082 2000              ftype_return equ   4
0083 2000
0084 2000              ; Stack frame for moveblock
0085 2000
0086 2000              Source   equ   15                       ; 4-byte source address
0087 2000              Dest     equ   11                       ; 4-byte destination address
0088 2000              Count    equ   07                       ; 4-byte transfer count
0089 2000              ReturnMove equ   05                     ; 3-byte return address
0090 2000              TempCount equ   03                      ; 2-byte temporary transfer count
0091 2000
0092 2000              ; START.GS.OS location equate
0093 2000
0094 2000              start_loc equ   $006800                 ; where START.GS.OS is loaded
0095 2000
0096 2000              ; block buffer equates
0097 2000
0098 2000              blkbuf   equ   $003000                  ; bank 0 block buffer
0099 2000              indexblkbuf equ   blkbuf+$0200          ; bank 0 index block buffer
0100 2000
0101 2000              ; cache equates
0102 2000
0103 2000              cache1   equ   blkbuf+$0400             ; first block cache
0104 2000              cache2   equ   blkbuf+$0600             ; second block cache
0105 2000
0106 2000              ; GS/OS error equates
0107 2000
0108 2000              file_not_found equ   $46
0109 2000
0110 2000              ; volume directory equates
0111 2000
0112 2000              voldir   equ   $02                      ; block number of start of volume dir
0113 2000
0114 2000              ; directory block offsets
0115 2000
0116 2000              fwdlink  equ   $02                      ; offset to forward block link
0117 2000              namelen  equ   $04                      ; offset to volname length byte
0118 2000              casebits equ   $1A                      ; offset to upper/lower case info (word)
0119 2000              entlen   equ   $23                      ; offset to file entry length byte
0120 2000              entsinblk equ   $24                     ; offset to # of entries in block
0121 2000              filecount equ   $25                     ; offset to # of active entries
0122 2000              hdr_offset equ   $04                    ; offset to header in directory block
0123 2000
0124 2000              ; file entry offsets
0125 2000
0126 2000              storagetype equ   $00                   ; offset to storage type - hi nibble
0127 2000              filetype equ   $10                      ; offset to file type - 1 byte
0128 2000              keypntr  equ   $11                      ; offset to key block of file - 2 bytes
0129 2000              eof      equ   $15                      ; offset to eof - 3 bytes
0130 2000              auxtype  equ   $1f                      ; offset to aux type - 2 bytes
0131 2000
0132 2000              ; emulation zero page equates
0133 2000
0134 2000              devcmd   equ   $42                      ; Device command
0135 2000              devunit  equ   $43                      ; Device unit number for device I/O.
0136 2000              devbuf   equ   $44                      ; Block buffer for device I/O.
0137 2000              devblk   equ   $46                      ; Device block number for device I/O.
0138 2000
0139 2000              ; monitor equates
0140 2000
0141 2000              idroutine equ   $fe1f                   ; //GS id routine
0142 2000              setvid   equ   $fe93                    ; Does a PR#0 to put COUT1 in CSW.
0143 2000              setnorm  equ   $fe84                    ; Normal white text on black backround.
0144 2000              init     equ   $fb2f                    ; Text pg1; text mode; sets 40/80 col w
0145 2000              home     equ   $fc58                    ; Monitor's clear screen routine.
0146 2000
0147 2000              ; hardware equates
0148 2000
0149 2000              clr80col equ   $c000                    ; disable 80 column store
0150 2000              clr80vid equ   $c00c                    ; disable 80 column hardware
0151 2000              clraltchar equ   $c00e                  ; normal lc, flashing uc
0152 2000
0153 2000              ; language card soft switch equates
0154 2000
0155 2000              romin    equ   $c081                    ; enable rom read, 2 reads write enb LC ram
0156 2000
0157 2000              ; misc. equates
0158 2000
0159 2000              mslot    equ   $07f8                    ; slot # of boot device
0160 2000              screen   equ   $05a8                    ; Row 11 of 40 column screen
0161 2000              screen2  equ   $06a8                    ; Row 13 of 40 column screen
0162 2000              emulstack equ   $010100                 ; emulation stack ptr is saved here
0163 2000
0164 2000
0165 2000
0166 2000              ;===============================================================================
0167 2000              ; jump table
0168 2000              ;===============================================================================
0169 2000
0170 2000                       EXPORT jump_table
0171 2000              jump_table PROC 
0172 2000
0173 2000                       longa on
0174 2000                       longi on
0175 2000
0176 2000 4C FC 23              jmp   |startup                 ;3 bytes
0177 2003 EA                    nop                            ;1 byte of padding
0178 2004 0E 20                 DC W:readinfile                ;offset into table = 4
0179 2006 74 23                 DC W:getbootname               ;offset into table = 6
0180 2008 D4 23                 DC W:getfstname                ;offset into table = 8
0181 200A D4 03                 DC W:getfstname-jump_table     ;size of permanent code
0182 200C                       EXPORT aux_value               ;aux type of START.GS.OS file
0183 200C 00 00        aux_value DC W:0                        ;offset into table = 12
0184 200E
0185 200E                       ENDP 
0186 200E
0187 200E
0188 200E
0189 200E              ;===============================================================================
0190 200E              ; readinfile
0191 200E              ;
0192 200E              ; Entry is in 16-bit native mode.
0193 200E              ; Exit is in 16-bit native mode.
0194 200E              ; Data bank register is preserved.
0195 200E              ; Direct register is preserved.
0196 200E              ;
0197 200E              ; Inputs:       4 bytes - space for eof result
0198 200E              ;               2 bytes - space for aux type result
0199 200E              ;               2 bytes - space for file type result
0200 200E              ;               4 bytes - pointer to partial pathname of file to read
0201 200E              ;               4 bytes - pointer to buffer to read file into
0202 200E              ;
0203 200E              ; Outputs:      c - 0 if file read successful, 1 if not
0204 200E              ;               A - error code if c=1
0205 200E              ;               file's eof on stack (4 bytes)
0206 200E              ;               file's auxtype on stack (2 bytes)
0207 200E              ;               file's filetype on stack (2 bytes)
0208 200E              ;
0209 200E              ; This routine will find the requested file and read it into memory.
0210 200E              ; The file's eof, auxtype and filetype are returned on the stack.
0211 200E              ; The partial pathname is class 1 format; the filenames are separated
0212 200E              ; by colons; there are no leading or trailing colons.
0213 200E              ;
0214 200E              ; NOTE - this routine assumes the file being read is a sapling file !!
0215 200E              ;=============================================================================
0216 200E
0217 200E                       EXPORT readinfile
0218 200E              readinfile PROC 
0219 200E
0220 200E                       longa on
0221 200E                       longi on
0222 200E
0223 200E              ;save current direct register and set it to point to our data area
0224 200E
0225 200E 7B                    tdc   
0226 200F F4 84 26              pea   dp_start
0227 2012 2B                    pld   
0228 2013 85 00                 sta   <save_d
0229 2015
0230 2015              ;pull inputs off stack
0231 2015
0232 2015 FA                    plx                            ;pull return address off stack
0233 2016 68                    pla                            ;pull pointer to buffer off stack
0234 2017 85 0C                 sta   <buffer_ptr              ;and save
0235 2019 68                    pla   
0236 201A 85 0E                 sta   <buffer_ptr+2
0237 201C 68                    pla                            ;pull pointer to pathname off stack
0238 201D 85 08                 sta   <path_ptr                ;and save
0239 201F 68                    pla   
0240 2020 85 0A                 sta   <path_ptr+2
0241 2022 DA                    phx                            ;push return address back on stack
0242 2023
0243 2023              ;initialize pathname information
0244 2023
0245 2023 A9 01 00              lda   #1
0246 2026 85 06                 sta   <path_index              ;initialize index into pathname
0247 2028 A7 08                 lda   [<path_ptr]              ;get length of pathname
0248 202A 1A                    inc   a                        ;add 1 for extra length byte
0249 202B 85 04                 sta   <path_len                ;and save
0250 202D
0251 202D              ;initialize entryadr to 0
0252 202D
0253 202D 64 16                 stz   <entryadr
0254 202F
0255 202F              ;save data bank register and set it to bank $00
0256 202F
0257 202F 8B                    phb   
0258 2030 4B                    phk   
0259 2031 AB                    plb   
0260 2032
0261 2032              ;pull filename off pathname and find its file entry
0262 2032              ;continue until have found file entry for final filename in pathname
0263 2032
0264 2032              file_loop  
0265 2032 20 B9 20              jsr   get_filename             ;extract next filename from pathname
0266 2035 B0 07                 bcs   found_last               ;carry set if at end of pathname
0267 2037 20 D9 20              jsr   find_file_entry          ;find the file entry for the filename
0268 203A B0 5E                 bcs   err_ret                  ;if carry set, error is in A
0269 203C 80 F4                 bra   file_loop
0270 203E
0271 203E              ;we now have the file entry for the file we are to load...
0272 203E
0273 203E              ;get the file's eof, save it for later and return it on the stack
0274 203E
0275 203E              found_last  
0276 203E A0 15 00              ldy   #eof                     ;get eof and save for later
0277 2041 B1 16                 lda   (<entryadr),y
0278 2043 85 10                 sta   <file_eof
0279 2045 83 08                 sta   eof_return,s             ;and return on stack
0280 2047 C8                    iny                            ;get third byte (word) too
0281 2048 C8                    iny   
0282 2049 B1 16                 lda   (<entryadr),y
0283 204B 29 FF 00              and   #$00ff                   ;high byte must be $00
0284 204E 85 12                 sta   <file_eof+2
0285 2050 83 0A                 sta   eof_return+2,s
0286 2052
0287 2052              ;get the file's aux type and return it on the stack
0288 2052
0289 2052 A0 1F 00              ldy   #auxtype                 ;offset to aux type
0290 2055 B1 16                 lda   (<entryadr),y            ;get aux type from file entry
0291 2057 83 06                 sta   atype_return,s           ;return on stack
0292 2059
0293 2059              ;get the file's file type and return it on the stack
0294 2059
0295 2059 A0 10 00              ldy   #filetype                ;offset to file type
0296 205C B1 16                 lda   (<entryadr),y            ;get file type from file entry
0297 205E 29 FF 00              and   #$00ff                   ;only lo byte is valid
0298 2061 83 04                 sta   ftype_return,s           ;return on stack
0299 2063
0300 2063              ;read in file's key block
0301 2063
0302 2063 A0 11 00              ldy   #keypntr                 ;Key block pointer offset.
0303 2066 B1 16                 lda   (<entryadr),y            ;Load key blk pointer.
0304 2068 A8                    tay                            ;Save in Y for Readblock call.
0305 2069 A2 00 32              ldx   #indexblkbuf             ;set up ptr to index block buffer
0306 206C A9 00 00              lda   #0                       ;buffer is in bank $00
0307 206F 20 A1 21              jsr   read_block
0308 2072 B0 26                 bcs   err_ret                  ;if carry set, A contains error
0309 2074
0310 2074              ;now, read the file into memory
0311 2074
0312 2074 A5 11                 lda   <file_eof+1              ;how many blocks do we read in????
0313 2076 4A                    lsr   a                        ;divide by 2
0314 2077 AA                    tax                            ;save in x while we check for leftovers
0315 2078 A5 10                 lda   <file_eof                ;get low word of eof
0316 207A 29 FF 01              and   #$01ff                   ;we only want to test low 9 bits
0317 207D F0 01                 beq   num_blks_ok              ;= then we already have the correct num
0318 207F E8                    inx                            ;add one for safety
0319 2080              num_blks_ok  
0320 2080 86 14                 stx   <num_blks                ;save as our counter
0321 2082 A2 FF FF              ldx   #$ffff                   ;offset into index table-1
0322 2085 86 12                 stx   <indexblkoff
0323 2087
0324 2087              read_all  
0325 2087 E6 12                 inc   <indexblkoff             ; increment index into index block
0326 2089 A9 00 32              lda   #indexblkbuf             ; Set up to get the data block
0327 208C A4 12                 ldy   <indexblkoff             ; address of the file on disk.
0328 208E 20 8E 21              jsr   getblknum                ; Get the block number in Y.
0329 2091 A5 0E                 lda   <buffer_ptr+2            ; put ptr to buffer in A and X
0330 2093 A6 0C                 ldx   <buffer_ptr
0331 2095 20 A1 21              jsr   read_block               ; Read 1st data block.
0332 2098 90 07                 bcc   rdok1                    ; Branch if successful read.
0333 209A              err_ret   
0334 209A AB                    plb                            ; restore data bank register
0335 209B 48                    pha                            ; save error code
0336 209C A5 00                 lda   <save_d
0337 209E 5B                    tcd                            ; restore direct register
0338 209F 68                    pla                            ; retrieve error code
0339 20A0 60                    rts                            ; carry set, error code in A
0340 20A1
0341 20A1              rdok1     
0342 20A1
0343 20A1              ;now we must decrement the number of blocks counter by 1 block
0344 20A1
0345 20A1 C6 14                 dec   <num_blks
0346 20A3 F0 0E                 beq   done
0347 20A5
0348 20A5              ;now we must increment pointer by 1 block
0349 20A5
0350 20A5 18                    clc   
0351 20A6 A5 0C                 lda   <buffer_ptr              ;low word of destination pointer
0352 20A8 69 00 02              adc   #$0200                   ;add one block
0353 20AB 85 0C                 sta   <buffer_ptr
0354 20AD 90 D8                 bcc   read_all
0355 20AF E6 0E                 inc   <buffer_ptr+2
0356 20B1 80 D4                 bra   read_all
0357 20B3
0358 20B3              ;done with read - return to caller
0359 20B3
0360 20B3              done      
0361 20B3 AB                    plb                            ;restore data bank register
0362 20B4 A5 00                 lda   <save_d
0363 20B6 5B                    tcd                            ;restore direct register
0364 20B7 18                    clc                            ;indicate no error
0365 20B8 60                    rts                            ;back to caller
0366 20B9
0367 20B9                       ENDP 
0368 20B9
0369 20B9
0370 20B9
0371 20B9              ;===============================================================================
0372 20B9              ; get_filename
0373 20B9              ;
0374 20B9              ; Entry is in 16-bit native mode.
0375 20B9              ; Exit is in 16-bit native mode.
0376 20B9              ; Data bank register is set to bank $00 on entry and exit.
0377 20B9              ; Direct register is set to point to local data area on entry and exit.
0378 20B9              ;
0379 20B9              ; Inputs:       <path_ptr - points to a pathname
0380 20B9              ;               <path_index - contains the current index into the pathname
0381 20B9              ;               <path_len - contains the length of the pathname
0382 20B9              ;
0383 20B9              ; Outputs:      c - 1 if at end of pathname, else 0
0384 20B9              ;               <filename - contains the extracted filename in class 0 format
0385 20B9              ;                           with no leading or trailing separators
0386 20B9              ;
0387 20B9              ; This routine extracts the next local filename from a pathname.
0388 20B9              ;===============================================================================
0389 20B9
0390 20B9                       EXPORT get_filename
0391 20B9              get_filename PROC 
0392 20B9
0393 20B9                       longa off
0394 20B9                       longi off
0395 20B9 E2 30                 sep   #$30                     ; ***** begin 8-bit mode *****
0396 20BB
0397 20BB A4 06                 ldy   <path_index              ;get current index into pathname
0398 20BD C4 04                 cpy   <path_len                ;are we at end of pathname?
0399 20BF B0 15                 bcs   done                     ;yes - so return carry set
0400 20C1
0401 20C1 A2 00                 ldx   #0                       ;initialize index into filename
0402 20C3
0403 20C3              loop      
0404 20C3 C8                    iny   
0405 20C4 B7 08                 lda   [<path_ptr],y            ;get next character from pathname
0406 20C6 C9 3A                 cmp   #':'                     ;if it's ':', we're at end of filename
0407 20C8 F0 07                 beq   cont
0408 20CA E8                    inx   
0409 20CB 95 2C                 sta   <filename,x              ;store character in local string
0410 20CD C4 04                 cpy   <path_len                ;are we at the end of the pathname?
0411 20CF D0 F2                 bne   loop                     ;no - so continue
0412 20D1
0413 20D1              cont      
0414 20D1 84 06                 sty   <path_index              ;save new index into pathname
0415 20D3 86 2C                 stx   <filename                ;store length of filename
0416 20D5 18                    clc                            ;indicate no error
0417 20D6
0418 20D6              done      
0419 20D6                       longa on
0420 20D6                       longi on
0421 20D6 C2 30                 rep   #$30                     ; ***** return to 16-bit mode *****
0422 20D8
0423 20D8 60                    rts   
0424 20D9                       ENDP 
0425 20D9
0426 20D9
0427 20D9
0428 20D9              ;===============================================================================
0429 20D9              ; find_file_entry
0430 20D9              ;
0431 20D9              ; Entry is in 16-bit native mode.
0432 20D9              ; Exit is in 16-bit native mode.
0433 20D9              ; Data bank register is set to bank $00 on entry and exit.
0434 20D9              ; Direct register is set to point to local data area on entry and exit.
0435 20D9              ;
0436 20D9              ; Inputs:       <entryadr - contains 0 if volume directory should be searched
0437 20D9              ;                           else contains the address of the file entry of the
0438 20D9              ;                           directory to be searched
0439 20D9              ;               <filename - contains the filename we are searching for
0440 20D9              ;
0441 20D9              ; Outputs:      c - 0 if file entry found, 1 if not
0442 20D9              ;               A - contains error code if c=1
0443 20D9              ;               <entryadr - contains address of file entry if c=0
0444 20D9              ;
0445 20D9              ; This routine will look through a directory for the entry of a specified file.
0446 20D9              ;===============================================================================
0447 20D9
0448 20D9                       EXPORT find_file_entry 
0449 20D9              find_file_entry PROC  
0450 20D9
0451 20D9                       longa on
0452 20D9                       longi on
0453 20D9
0454 20D9 64 20                 stz   <entrieschkd             ; Init running no. of checked entries.
0455 20DB A9 01 00              lda   #1
0456 20DE 85 24                 sta   <header_flag             ;indicate that we're reading header blk
0457 20E0
0458 20E0 A0 02 00              ldy   #voldir
0459 20E3 A5 16                 lda   <entryadr                ;if entryadr=0 then read volume dir
0460 20E5 F0 13                 beq   next_block
0461 20E7
0462 20E7 A0 00 00              ldy   #storagetype             ;offset to storage type
0463 20EA B1 16                 lda   (<entryadr),y            ;get storage type
0464 20EC 29 F0 00              and   #$00f0                   ;need hi nibble of lo byte only
0465 20EF C9 D0 00              cmp   #$00d0                   ;is it a subdirectory?
0466 20F2 D0 46                 bne   nofile                   ;no - so report an error
0467 20F4
0468 20F4 A0 11 00              ldy   #keypntr                 ;offset to key block pointer
0469 20F7 B1 16                 lda   (<entryadr),y            ;get key blk pointer
0470 20F9 A8                    tay                            ;put in Y for Readblock call
0471 20FA
0472 20FA              next_block  
0473 20FA A2 00 30              ldx   #blkbuf                  ;set up ptr to block buffer
0474 20FD A9 00 00              lda   #0                       ;bank
0475 2100 20 A1 21              jsr   read_block               ;read the block
0476 2103 B0 38                 bcs   readerr                  ;if carry set, A contains error
0477 2105
0478 2105 A5 24                 lda   <header_flag             ;was this a header block?
0479 2107 F0 15                 beq   not_hdr                  ;no
0480 2109 AD 23 30              lda   |blkbuf+entlen           ;get length of file entry
0481 210C 29 FF 00              and   #$00ff                   ;zero hi byte
0482 210F 85 18                 sta   <entrylen                ;and save
0483 2111 AD 24 30              lda   |blkbuf+entsinblk        ;get # of entries in block
0484 2114 29 FF 00              and   #$00ff                   ;zero hi byte
0485 2117 85 1A                 sta   <entsperblk              ;and save
0486 2119 AD 25 30              lda   |blkbuf+filecount        ;get # of active entries in dir
0487 211C 85 22                 sta   <nfilestochk             ;and save
0488 211E              not_hdr   
0489 211E
0490 211E 20 41 21              jsr   chkdirblk                ; Go look for file.
0491 2121 90 1C                 bcc   gotit                    ; Branch if file found.
0492 2123 18                    clc                            ; update # of entries checked
0493 2124 A5 1E                 lda   <entsactive
0494 2126 65 20                 adc   <entrieschkd
0495 2128 85 20                 sta   <entrieschkd
0496 212A C5 22                 cmp   <nfilestochk             ; Have we compared all entries?
0497 212C F0 0C                 beq   nofile                   ; Branch if so..no match found.
0498 212E
0499 212E A2 02 00              ldx   #fwdlink                 ; Load forward directory
0500 2131 BC 00 30              ldy   |blkbuf,x                ; block pointer.
0501 2134 F0 04                 beq   nofile                   ; Branch if no more dir to search.
0502 2136 64 24                 stz   <header_flag
0503 2138 80 C0                 bra   next_block               ; Go check next directory block.
0504 213A
0505 213A              nofile    
0506 213A A9 46 00              lda   #file_not_found          ;set error #
0507 213D              readerr   
0508 213D 38                    sec                            ;indicate error
0509 213E 60                    rts   
0510 213F
0511 213F              gotit     
0512 213F 18                    clc                            ;indicate no error
0513 2140 60                    rts   
0514 2141
0515 2141
0516 2141              ;-------------------------------------------------------------------------------
0517 2141              ; chkdirblk
0518 2141              ;
0519 2141              ; Entry is in 16-bit native mode.
0520 2141              ; Exit is in 16-bit native mode.
0521 2141              ; Data bank register is set to bank $00 on entry and exit.
0522 2141              ; Direct register is set to point to local data area on entry and exit.
0523 2141              ;
0524 2141              ; Inputs:       directory block is in 'blkbuf'
0525 2141              ;               <entsperblk - contains # of file entries per block
0526 2141              ;               <entrylen - contains length of file entry
0527 2141              ;
0528 2141              ; Outputs:      c - 0 if file entry found, 1 if not
0529 2141              ;               <entryadr - contains address of file entry if c=0
0530 2141              ;               <entsactive - contains # of active entries checked
0531 2141              ;
0532 2141              ; Checks a given directory block for a file entry with a given filename.
0533 2141              ;-------------------------------------------------------------------------------
0534 2141
0535 2141              chkdirblk  
0536 2141                       longa on
0537 2141                       longi on
0538 2141
0539 2141 64 1E                 stz   <entsactive              ; Init active entry count to zero.
0540 2143 A5 1A                 lda   <entsperblk              ; Save number of entries per blk
0541 2145 85 1C                 sta   <numentries              ; in a working temp.
0542 2147
0543 2147 A9 00 30              lda   #blkbuf                  ; Adjust address of 
0544 214A 18                    clc                            ; directory block past
0545 214B 69 04 00              adc   #4                       ; the block pointers.
0546 214E 85 16                 sta   <entryadr                ; And store in entry pointer.
0547 2150
0548 2150 A6 24                 ldx   <header_flag
0549 2152 F0 0B                 beq   notheader                ; Branch if not a key dir blk.
0550 2154
0551 2154              chknxtentry  
0552 2154 18                    clc                            ; Adjust to next entry.
0553 2155 A5 16                 lda   <entryadr
0554 2157 65 18                 adc   <entrylen
0555 2159 85 16                 sta   <entryadr
0556 215B C6 1C                 dec   <numentries              ; One less entry to search.
0557 215D F0 0F                 beq   notfound                 ; Branch if no more entries.
0558 215F              notheader  
0559 215F B2 16                 lda   (<entryadr)              ; Is entry active?
0560 2161 29 FF 00              and   #$00ff                   ; Strip off hi byte.
0561 2164 F0 EE                 beq   chknxtentry              ; not active so check next entry
0562 2166 E6 1E                 inc   <entsactive              ; Update active entry count.
0563 2168 20 70 21              jsr   check_name               ; Is this the entry we're looking for?
0564 216B B0 E7                 bcs   chknxtentry              ; no - so check next entry
0565 216D 60                    rts                            ; carry is clear
0566 216E
0567 216E              notfound  
0568 216E 38                    sec                            ; indicate entry not found
0569 216F 60                    rts   
0570 2170
0571 2170
0572 2170              ;-------------------------------------------------------------------------------
0573 2170              ; check_name
0574 2170              ;
0575 2170              ; Entry is in 16-bit native mode.
0576 2170              ; Exit is in 16-bit native mode.
0577 2170              ; Data bank register is set to bank $00 on entry and exit.
0578 2170              ; Direct register is set to point to local data area on entry and exit.
0579 2170              ;
0580 2170              ; Inputs:       <entryadr - contains address of file entry to check
0581 2170              ;               <filename - contains filename to match
0582 2170              ;
0583 2170              ; Outputs:      c - 0 if filename matches, 1 if not
0584 2170              ;
0585 2170              ; Checks a file entry for a match to a specified filename.
0586 2170              ;-------------------------------------------------------------------------------
0587 2170
0588 2170              check_name  
0589 2170                       longa off
0590 2170                       longi off
0591 2170 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0592 2172
0593 2172 B2 16                 lda   (<entryadr)              ; Get length of filename.
0594 2174 29 0F                 and   #$0f                     ; Strip off hi nibble.
0595 2176 C5 2C                 cmp   <filename                ; Are the filenames the same length?
0596 2178 D0 10                 bne   nomatch                  ; no
0597 217A A8                    tay                            ; xfer filename length to Y
0598 217B AA                    tax                            ; and X
0599 217C B1 16        nxtchar  lda   (<entryadr),y            ; compare filename
0600 217E D5 2C                 cmp   <filename,x
0601 2180 D0 08                 bne   nomatch                  ; they're not the same
0602 2182 88                    dey   
0603 2183 CA                    dex   
0604 2184 D0 F6                 bne   nxtchar                  ; Go check next char in filename.
0605 2186 18                    clc                            ; signify match
0606 2187 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0607 2189 60                    rts   
0608 218A
0609 218A              nomatch   
0610 218A 38                    sec                            ; Signify no match.
0611 218B C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0612 218D 60                    rts   
0613 218E                       ENDP 
0614 218E
0615 218E
0616 218E
0617 218E              ;===============================================================================
0618 218E              ; getblknum
0619 218E              ;
0620 218E              ; Entry is in 16-bit native mode.
0621 218E              ; Exit is in 16-bit native mode.
0622 218E              ; Data bank register is set to bank $00 on entry and exit.
0623 218E              ; Direct register is set to point to local data area on entry and exit.
0624 218E              ;
0625 218E              ; Inputs:       A - Memory address of index block.
0626 218E              ;               Y - Offset into index block.
0627 218E              ;
0628 218E              ; Outputs:      Y - Returns block number from index block.
0629 218E              ;
0630 218E              ; Getblknum will return the block number wanted from the given index block.
0631 218E              ;===============================================================================
0632 218E
0633 218E                       EXPORT getblknum
0634 218E              getblknum PROC 
0635 218E
0636 218E                       longa on
0637 218E                       longi on
0638 218E
0639 218E 85 28                 sta   <lopage                  ; Store index blk adr. in z-page.
0640 2190 18                    clc                            ; Now calculate adr. of hi page
0641 2191 69 00 01              adc   #256                     ; of index block for indexing reasons..
0642 2194 85 2A                 sta   <hipage                  ; And store it.
0643 2196
0644 2196                       longa off
0645 2196 E2 20                 sep   #$20                     ; ***** begin 8-bit m *****
0646 2198
0647 2198 B1 2A                 lda   (<hipage),y              ; Get hi byte of block number.
0648 219A EB                    xba                            ; Save in lo byte of A.
0649 219B B1 28                 lda   (<lopage),y              ; Get the low byte of the block number.
0650 219D
0651 219D                       longa on
0652 219D C2 20                 rep   #$20                     ; ***** return to 16 bit m *****
0653 219F
0654 219F A8                    tay                            ; Return block number in Y.
0655 21A0 60                    rts                            ; Done.
0656 21A1                       ENDP 
0657 21A1
0658 21A1
0659 21A1
0660 21A1              ;===============================================================================
0661 21A1              ; read_block
0662 21A1              ;
0663 21A1              ; This is the new READ_BLOCK routine.
0664 21A1              ; A call structure for an extended SmartPort interface will
0665 21A1              ; be built for the requested block.  If the ProDOS interface
0666 21A1              ; is indicated then the extended SmartPort call will be
0667 21A1              ; translated into a ProDOS call prior to passing control to
0668 21A1              ; the firmware interface.  ProDOS calls will be followed by
0669 21A1              ; a block move call.
0670 21A1              ; If read_block gets a $2E error (disk switched) it will retry the call once.
0671 21A1              ;
0672 21A1              ; This routine uses a very simple form of block caching.  The first two blocks
0673 21A1              ; read are copied into two cache areas in memory.  Then, when we need to read
0674 21A1              ; these blocks again, they are just copied from the cache instead of read from
0675 21A1              ; the device. This is done to speed up booting of GS/OS since we know that the
0676 21A1              ; first two blocks read are the volume directory block and the SYSTEM directory
0677 21A1              ; block.  These blocks are needed repeatedly during boot so we save a little
0678 21A1              ; time by caching them.
0679 21A1              ;
0680 21A1              ; ENTRY: via a 'JSR'
0681 21A1              ;               A Reg = Buffer address (high word)
0682 21A1              ;               X Reg = Buffer address (low word)
0683 21A1              ;               Y Reg = Sparse Flag if $0000 or block number
0684 21A1              ;            Bank Reg = $00
0685 21A1              ;             Dir Reg = Local data area
0686 21A1              ;               P Reg = N V M X D I Z C   E
0687 21A1              ;                       x x 0 0 0 x x x   0
0688 21A1              ;
0689 21A1              ; EXIT: via a 'RTS'
0690 21A1              ;               A Reg = Error code
0691 21A1              ;               X Reg = Unknown
0692 21A1              ;               Y Reg = Unknown
0693 21A1              ;            Bank Reg = $00
0694 21A1              ;             Dir Reg = Local data area
0695 21A1              ;               P Reg = N V M X D I Z C   E
0696 21A1              ;                       x x 0 0 0 x x 0   0  if no error occured
0697 21A1              ;                       x x 0 0 0 x x 1   0  if error occured
0698 21A1              ;
0699 21A1              ;===============================================================================
0700 21A1
0701 21A1                       EXPORT read_block
0702 21A1              read_block PROC 
0703 21A1
0704 21A1                       longa on
0705 21A1                       longi on
0706 21A1
0707 21A1 0B                    phd                            ;save current direct register
0708 21A2 F4 00 00              pea   $0000                    ;set up emulation zero page
0709 21A5 2B                    pld   
0710 21A6
0711 21A6              ; Assume that an extended SmartPort call will be issued and
0712 21A6              ; setup the data neccessary for the call.
0713 21A6              ; Also, set up data neccessary for a ProDOS call.
0714 21A6
0715 21A6 9C EE 22              stz   |retry_flag              ;initialize the retry flag
0716 21A9
0717 21A9 8D E6 22              sta   |sp_buffer+2
0718 21AC 8E E4 22              stx   |sp_buffer
0719 21AF 86 44                 stx   <devbuf
0720 21B1 8C E8 22              sty   |sp_block
0721 21B4 84 46                 sty   <devblk
0722 21B6 9C EA 22              stz   |sp_block+2
0723 21B9 AD EC 22              lda   |slot_num                ; get $Cnxx
0724 21BC 0A                    asl   a
0725 21BD 0A                    asl   a
0726 21BE 0A                    asl   a
0727 21BF 0A                    asl   a
0728 21C0 29 00 70              and   #$7000
0729 21C3 09 01 00              ora   #$0001                   ; or in a read command
0730 21C6 85 42                 sta   <devcmd
0731 21C8 8D F0 22              sta   |save_devcmd             ;save it in case we need to retry call
0732 21CB
0733 21CB              ; if Y=0, then transfer 512 bytes of 0
0734 21CB
0735 21CB C0 00 00              cpy   #0                       ; should we transfer 512 bytes of zero?
0736 21CE D0 14                 bne   realblock                ; no
0737 21D0 AD E6 22              lda   |sp_buffer+2             ; set bank address of buffer
0738 21D3 85 46                 sta   <devbuf+2
0739 21D5 A0 FE 01              ldy   #510
0740 21D8 A9 00 00              lda   #0
0741 21DB 97 44        zero_loop sta   [<devbuf],y             ; transfer 512 bytes of zero
0742 21DD 88                    dey   
0743 21DE 88                    dey   
0744 21DF 10 FA                 bpl   zero_loop
0745 21E1 2B                    pld                            ; restore direct register
0746 21E2 18                    clc                            ; indicate no error
0747 21E3 60                    rts   
0748 21E4
0749 21E4              ; Y<>0 so we need to transfer a real block
0750 21E4              ;
0751 21E4              ; First, check to see if the block we want is in cache1 and if so, copy it
0752 21E4              ; from the cache into the destination buffer
0753 21E4
0754 21E4              realblock  
0755 21E4 CC F2 22              cpy   |cache1_num              ; is the block in the first cache?
0756 21E7 D0 14                 bne   check2                   ; no
0757 21E9 AD E6 22              lda   |sp_buffer+2             ; set bank address of buffer
0758 21EC 85 46                 sta   <devbuf+2
0759 21EE A0 FE 01              ldy   #510
0760 21F1 B9 00 34     cache1_loop lda   |cache1,y             ; copy block from cache1 into buffer
0761 21F4 97 44                 sta   [<devbuf],y
0762 21F6 88                    dey   
0763 21F7 88                    dey   
0764 21F8 10 F7                 bpl   cache1_loop
0765 21FA              cache_ret  
0766 21FA 2B                    pld                            ; restore direct register
0767 21FB 18                    clc                            ; indicate no error
0768 21FC 60                    rts   
0769 21FD
0770 21FD              ; The block we want is not in cache1 so check to see if it's in cache2 and
0771 21FD              ; if so, copy it from the cache into the destination buffer
0772 21FD
0773 21FD              check2    
0774 21FD CC F4 22              cpy   |cache2_num              ; is the block in the second cache?
0775 2200 D0 13                 bne   notcached                ; no
0776 2202 AD E6 22              lda   |sp_buffer+2             ; set bank address of buffer
0777 2205 85 46                 sta   <devbuf+2
0778 2207 A0 FE 01              ldy   #510
0779 220A B9 00 36     cache2_loop lda   |cache2,y             ; copy block from cache2 into buffer
0780 220D 97 44                 sta   [<devbuf],y
0781 220F 88                    dey   
0782 2210 88                    dey   
0783 2211 10 F7                 bpl   cache2_loop
0784 2213 80 E5                 bra   cache_ret
0785 2215
0786 2215              notcached                               ; the block is not cached so read it
0787 2215
0788 2215              ; Determine if the SmartPort or ProDOS interface will be called.
0789 2215
0790 2215              make_the_call  
0791 2215 AD D3 22              lda   |godev+2                 ; will ProDOS or SmartPort be called?
0792 2218 30 05                 bmi   go_prodos
0793 221A
0794 221A              ; Call the SmartPort interface.
0795 221A
0796 221A 20 BE 22              jsr   stack_futz               ; call the SmartPort interface
0797 221D 80 2C                 bra   read_done
0798 221F
0799 221F              ; Call the ProDOS interface.
0800 221F              ; The data must be double buffered if a bank other than $00
0801 221F              ; is indicated.  If the buffer is in bank $00 then no double
0802 221F              ; buffering will take place.
0803 221F
0804 221F              go_prodos  
0805 221F AD E6 22              lda   |sp_buffer+2             ; buffer in bank $00?
0806 2222 D0 05                 bne   dbl_buffer               ; no, so need to double buffer
0807 2224 20 BE 22              jsr   stack_futz               ; call the ProDOS interface
0808 2227 80 22                 bra   read_done
0809 2229
0810 2229              ; The bank address is not in bank $00 so data must be double buffered
0811 2229              ; through bank $00 since ProDOS devices support only a word wide
0812 2229              ; buffer address in bank $00.
0813 2229
0814 2229              dbl_buffer  
0815 2229 A9 00 30              lda   #blkbuf                  ; read block into temporary buffer
0816 222C 85 44                 sta   <devbuf
0817 222E 20 BE 22              jsr   stack_futz               ; call the ProDOS interface
0818 2231 B0 18                 bcs   read_done
0819 2233
0820 2233              ; Copy data from bank $00 to ultimate destination.
0821 2233
0822 2233 F4 00 00              pea   blkbuf>>16               ; high word source address ptr
0823 2236 F4 00 30              pea   blkbuf                   ; low  word source address ptr
0824 2239 AD E6 22              lda   |sp_buffer+2             ; high word dest. address ptr
0825 223C 48                    pha   
0826 223D AD E4 22              lda   |sp_buffer               ; low  word dest. address ptr
0827 2240 48                    pha   
0828 2241 F4 00 00              pea   $0000                    ; high word block size
0829 2244 F4 00 02              pea   $0200                    ; low  word block size
0830 2247 20 F6 22              jsr   moveblock                ; move'em
0831 224A 18                    clc                            ; make sure no error
0832 224B
0833 224B              read_done  
0834 224B 29 FF 00              and   #$00FF                   ; mask off hi byte of error code if any
0835 224E 90 26                 bcc   no_error
0836 2250 89 40 00              bit   #$0040                   ;is it a soft error?
0837 2253 D0 21                 bne   no_error                 ;yes - so ignore it
0838 2255 C9 2E 00              cmp   #$002e                   ;was it disk switched?
0839 2258 D0 19                 bne   report_err               ;no - so report it
0840 225A AE EE 22              ldx   |retry_flag              ;have we already retried the call?
0841 225D D0 14                 bne   report_err               ;yes - so report the error
0842 225F EE EE 22              inc   |retry_flag              ;no - so retry the call
0843 2262 AD E4 22              lda   |sp_buffer               ;set up ZP params again in case the
0844 2265 85 44                 sta   <devbuf                  ;firmware trashed them
0845 2267 AD E8 22              lda   |sp_block
0846 226A 85 46                 sta   <devblk
0847 226C AD F0 22              lda   |save_devcmd
0848 226F 85 42                 sta   <devcmd
0849 2271 80 A2                 bra   make_the_call            ;make the call again
0850 2273
0851 2273              report_err  
0852 2273 38                    sec                            ;make sure carry is set
0853 2274 80 46                 bra   done
0854 2276
0855 2276              no_error  
0856 2276 18                    clc                            ;make sure carry is clear
0857 2277
0858 2277              ; Check to see if cache1 is used, and if not, copy the block into it.
0859 2277
0860 2277 AD F2 22              lda   |cache1_num              ; is the first cache used?
0861 227A D0 1E                 bne   check_2                  ; yes
0862 227C AD E8 22              lda   |sp_block                ; no - so save block number
0863 227F 8D F2 22              sta   |cache1_num
0864 2282 AD E6 22              lda   |sp_buffer+2             ; set the bank address of the buffer
0865 2285 85 46                 sta   <devbuf+2
0866 2287 AD E4 22              lda   |sp_buffer               ; restore buffer address since the
0867 228A 85 44                 sta   <devbuf                  ; firmware may have trashed it
0868 228C A0 FE 01              ldy   #510
0869 228F B7 44        cache1_loop2 lda   [<devbuf],y          ; copy block into first cache
0870 2291 99 00 34              sta   |cache1,y
0871 2294 88                    dey   
0872 2295 88                    dey   
0873 2296 10 F7                 bpl   cache1_loop2
0874 2298 80 22                 bra   done
0875 229A
0876 229A              ; Cache1 was already used so check cache2.
0877 229A
0878 229A              check_2   
0879 229A AD F4 22              lda   |cache2_num              ; is the second cache used?
0880 229D D0 1D                 bne   done                     ; yes - so no more cache space
0881 229F AD E8 22              lda   |sp_block                ; no - so save block number
0882 22A2 8D F4 22              sta   |cache2_num
0883 22A5 AD E6 22              lda   |sp_buffer+2             ; set the bank address of the buffer
0884 22A8 85 46                 sta   <devbuf+2
0885 22AA AD E4 22              lda   |sp_buffer               ; restore buffer address since the
0886 22AD 85 44                 sta   <devbuf                  ; firmware may have trashed it
0887 22AF A0 FE 01              ldy   #510
0888 22B2 B7 44        cache2_loop2 lda   [<devbuf],y          ; copy block into second cache
0889 22B4 99 00 36              sta   |cache2,y
0890 22B7 88                    dey   
0891 22B8 88                    dey   
0892 22B9 10 F7                 bpl   cache2_loop2
0893 22BB
0894 22BB 18                    clc                            ; indicate no error
0895 22BC
0896 22BC              done      
0897 22BC 2B                    pld                            ; restore direct register
0898 22BD 60                    rts   
0899 22BE
0900 22BE
0901 22BE              ;-------------------------------------------------------------------------------
0902 22BE              ; Time to stack futz and call the card.
0903 22BE
0904 22BE              stack_futz  
0905 22BE 3B                    tsc                            ; temporary save of native stack ptr
0906 22BF AA                    tax   
0907 22C0 E2 20                 sep   #$20                     ;***** begin 8-bit m *****
0908 22C2                       longa off
0909 22C2 EB                    xba                            ; get stack pointer page
0910 22C3 3A                    dec   a                        ; is stack in page $01?
0911 22C4 F0 08                 beq   alreadypg1               ; yes
0912 22C6 A9 01                 lda   #$01                     ; else set page 1 stack
0913 22C8 EB                    xba   
0914 22C9 AF 00 01 01           lda   >emulstack               ; get emulation stack ptr
0915 22CD 1B                    tcs                            ; set emulation stack ptr
0916 22CE DA           alreadypg1 phx                          ; save native mode stack ptr
0917 22CF 38                    sec   
0918 22D0 FB                    xce                            ;***** begin emulation mode *****
0919 22D1                       longi off
0920 22D1
0921 22D1              ; Call either the ProDOS or SmartPort firmware interface.
0922 22D1
0923 22D1                       EXPORT godev
0924 22D1              godev     
0925 22D1 20 0D C7              jsr   $C000                    ; call firmware interface.
0926 22D4 EA                    nop                            ; 5 NOP's may be replaced by a
0927 22D5 EA                    nop                            ; SmartPort call structure.
0928 22D6 EA                    nop   
0929 22D7 EA                    nop   
0930 22D8 EA                    nop   
0931 22D9
0932 22D9              ; Return to native mode after returning from firmware call.
0933 22D9
0934 22D9 08                    php                            ; preserve carry status
0935 22DA 18                    clc   
0936 22DB FB                    xce                            ;***** begin 8-bit native mode *****
0937 22DC 28                    plp                            ; restore carry status
0938 22DD C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0939 22DF                       longa on
0940 22DF                       longi on
0941 22DF FA                    plx                            ; restore native stack ptr
0942 22E0 9A                    txs   
0943 22E1 60                    rts   
0944 22E2
0945 22E2              ;-------------------------------------------------------------------------------
0946 22E2              ; The following data must reside with the read_block routine
0947 22E2
0948 22E2                       EXPORT read_plist
0949 22E2              read_plist                              ;SmartPort read call data structure
0950 22E2 03                    DC B:3                         ; parameter count (fixed)
0951 22E3 01                    DC B:1                         ; unit number     (fixed)
0952 22E4 00 00 00 00  sp_buffer DC L:0                        ; buffer ptr      (dynamic)
0953 22E8 00 00 00 00  sp_block DC L:0                         ; block ptr       (dynamic)
0954 22EC
0955 22EC                       EXPORT slot_num
0956 22EC 00 C7        slot_num DS B:2                         ;slot number of boot device
0957 22EE
0958 22EE 00 00        retry_flag DS B:2
0959 22F0
0960 22F0 00 00        save_devcmd DS B:2
0961 22F2
0962 22F2              ;-------------------------------------------------------------------------------
0963 22F2              ; cache data - must be in permanent code area
0964 22F2              ;
0965 22F2              ; When GLoader saves the permanent code area in the language card, cache1_num
0966 22F2              ; and cache2_num must be 0 so that when GQuit moves the code back to bank 0
0967 22F2              ; to reload GS/OS, the code will know that the cache is not valid.
0968 22F2              ; So, the startup routine must zero cache1_num and cache2_num just before it
0969 22F2              ; transfers control to GLoader.
0970 22F2              ; Because of this, cache1_num and cache2_num are initialized to 1 so that
0971 22F2              ; we don't waste time caching during the startup routine since the cache will
0972 22F2              ; be marked as invalid as soon as control is transfered to GLoader.
0973 22F2
0974 22F2                       EXPORT cache1_num
0975 22F2 01 00        cache1_num DC W:1                       ; number of block in cache1
0976 22F4                       EXPORT cache2_num
0977 22F4 01 00        cache2_num DC W:1                       ; number of block in cache2
0978 22F6
0979 22F6
0980 22F6                       ENDP 
0981 22F6
0982 22F6
0983 22F6
0984 22F6              ;===============================================================================
0985 22F6              ; moveblock
0986 22F6              ;
0987 22F6              ; Moves a block of data from a source location to a destination location.
0988 22F6              ;
0989 22F6              ; Calling sequence:
0990 22F6              ;   Place machine in full native mode (e=0, m=0, x=0)
0991 22F6              ;   Push high order word of source pointer onto stack
0992 22F6              ;   Push low order word of source pointer
0993 22F6              ;   Push high order word of destination pointer
0994 22F6              ;   Push low order word of destination pointer
0995 22F6              ;   Push high order word of transfer count
0996 22F6              ;   Push low order word of transfer count
0997 22F6              ;   jsr MoveBlock
0998 22F6              ;
0999 22F6              ; Outputs:      None
1000 22F6              ;
1001 22F6              ; Notes:        The high byte of Source, Dest, and Count must be zero
1002 22F6              ;               The source and destination blocks must not overlap
1003 22F6              ;               This routine contains self modifying code--it cannot run in ROM
1004 22F6              ;===============================================================================
1005 22F6
1006 22F6                       EXPORT moveblock
1007 22F6              moveblock PROC 
1008 22F6
1009 22F6                       longa on
1010 22F6                       longi on
1011 22F6
1012 22F6 48                    pha                            ; push two bytes on stack for TempCount
1013 22F7 0B                    phd                            ; save D
1014 22F8 3B                    tsc                            ; make direct page correspond to stack
1015 22F9 5B                    tcd   
1016 22FA
1017 22FA              ; get ready to do the move
1018 22FA
1019 22FA 8B                    phb                            ; save DBR on stack (MVN trashes it)
1020 22FB
1021 22FB A5 07                 lda   Count
1022 22FD 05 09                 ora   Count+2
1023 22FF F0 66                 beq   MoveAbort
1024 2301
1025 2301 A6 0F                 ldx   Source                   ; X = low word of Source
1026 2303 A4 0B                 ldy   Dest                     ; Y = low word of Dest
1027 2305
1028 2305              ; set up the self modifying code to contain dst src
1029 2305
1030 2305 A5 0D                 lda   Dest+2                   ; make sure high byte of Dest is 0
1031 2307 29 FF 00              and   #$00FF
1032 230A 85 0D                 sta   Dest+2
1033 230C A5 11                 lda   Source+2                 ; get source bank
1034 230E 29 FF 00              and   #$00FF                   ; make sure high byte of Source is 0
1035 2311 EB                    xba   
1036 2312 05 0D                 ora   Dest+2                   ; or in destination bank (high byte must be zero)
1037 2314 8F 55 23 00           sta   >DoMove+1                ; put bank values into MVN instruction (danger)
1038 2318
1039 2318              ; decrement Count because it contains actual transfer count whereas
1040 2318              ; remainder of routine assumes it contains transfer count - 1
1041 2318
1042 2318 A5 07                 lda   Count
1043 231A D0 02                 bne   ArA1
1044 231C C6 09                 dec   Count+2
1045 231E C6 07        ArA1     dec   Count
1046 2320
1047 2320              ; initialize TempCount
1048 2320
1049 2320 A5 07                 lda   Count
1050 2322 85 03                 sta   TempCount
1051 2324 80 18                 bra   mdFirst
1052 2326
1053 2326              ; main move loop
1054 2326
1055 2326 85 09        mdMore   sta   Count+2                  ; more bytes to move
1056 2328 AF 55 23 00           lda   >DoMove+1                ; A = SrcDst banks
1057 232C E0 01 00              cpx   #$0001                   ; bank cross? if X=0
1058 232F B0 03                 bcs   mdXNot0
1059 2331 69 00 01              adc   #$0100                   ; add 1 to source bank
1060 2334 C0 00 00     mdXNot0  cpy   #$0000                   ; did destination cross bank?
1061 2337 D0 01                 bne   mdYIs0
1062 2339 1A                    inc   a
1063 233A 8F 55 23 00  mdYIs0   sta   >DoMove+1
1064 233E              mdFirst   
1065 233E 8A                    txa                            ; if count > -X then bank cross
1066 233F 49 FF FF              eor   #$FFFF
1067 2342 C5 03                 cmp   TempCount
1068 2344 B0 02                 bcs   mdXOk
1069 2346 85 03                 sta   TempCount                ; only move -X bytes
1070 2348 98           mdXOk    tya                            ; will destination cross bank?
1071 2349 49 FF FF              eor   #$FFFF
1072 234C C5 03                 cmp   TempCount
1073 234E B0 02                 bcs   mdYOk
1074 2350 85 03                 sta   TempCount                ; only move -Y bytes
1075 2352 A5 03        mdYOk    lda   TempCount                ; get the number of bytes to move
1076 2354
1077 2354              ; the following 3 bytes are the actual move instruction
1078 2354              ; this routine dynamically modifies the source and destination banks
1079 2354
1080 2354 54           DoMove   DC B:$54                       ; opcode for MVN
1081 2355 00 00                 DC W:$0000                     ; destination/source bank
1082 2357
1083 2357 A5 07                 lda   Count                    ; Count = Count - bytes moved
1084 2359 18                    clc                            ; actual bytes moved 1 more than count
1085 235A E5 03                 sbc   TempCount
1086 235C 85 07                 sta   Count
1087 235E 85 03                 sta   TempCount
1088 2360 A5 09                 lda   Count+2
1089 2362 E9 00 00              sbc   #$0000
1090 2365 10 BF                 bpl   mdMore
1091 2367
1092 2367              ; clean up everything before returning
1093 2367
1094 2367              MoveAbort  
1095 2367 AB                    plb                            ; restore DBR
1096 2368
1097 2368 A5 05                 lda   ReturnMove               ; move return address past parameters
1098 236A 85 11                 sta   Source+2
1099 236C
1100 236C 2B                    pld                            ; restore D
1101 236D 3B                    tsc                            ; set S to proper value
1102 236E 18                    clc   
1103 236F 69 0E 00              adc   #$000e
1104 2372 1B                    tcs                            ;fix up stack
1105 2373 60                    rts   
1106 2374
1107 2374                       ENDP 
1108 2374
1109 2374
1110 2374
1111 2374              ;===============================================================================
1112 2374              ; getbootname
1113 2374              ;
1114 2374              ; Entry is in 16-bit native mode.
1115 2374              ; Exit is in 16-bit native mode.
1116 2374              ; Direct register is preserved.
1117 2374              ;
1118 2374              ; Inputs:       4 bytes - pointer to space for volume name
1119 2374              ;
1120 2374              ; Outputs:      c - 0 if successful, 1 if not
1121 2374              ;               A - error code if c=1
1122 2374              ;
1123 2374              ; This routine will return the name of the boot volume.
1124 2374              ; The string must be in class 1 format and must contain a leading colon but
1125 2374              ; not a trailing colon.
1126 2374              ;
1127 2374              ; Modified 4/27/89 to handle upper/lower case volume names. CAE
1128 2374              ;=============================================================================
1129 2374
1130 2374                       EXPORT getbootname
1131 2374              getbootname PROC 
1132 2374
1133 2374                       longa on
1134 2374                       longi on
1135 2374
1136 2374              ;save current direct register and set it to point to our data area
1137 2374
1138 2374 7B                    tdc   
1139 2375 F4 84 26              pea   dp_start
1140 2378 2B                    pld   
1141 2379 85 00                 sta   <save_d
1142 237B
1143 237B              ;pull inputs off stack
1144 237B
1145 237B FA                    plx                            ;pull return address off stack
1146 237C 68                    pla                            ;pull pointer to string off stack
1147 237D 85 08                 sta   <path_ptr                ;and save
1148 237F 68                    pla   
1149 2380 85 0A                 sta   <path_ptr+2
1150 2382 DA                    phx                            ;push return address back on stack
1151 2383
1152 2383              ;read block 2 of the boot volume
1153 2383
1154 2383 A9 00 00              lda   #0                       ;bank
1155 2386 A2 00 30              ldx   #blkbuf                  ;ptr to block buffer
1156 2389 A0 02 00              ldy   #voldir                  ;block # to read
1157 238C 20 A1 21              jsr   read_block               ;read the block
1158 238F B0 37                 bcs   done
1159 2391
1160 2391              ;copy volume name into caller's area
1161 2391
1162 2391 64 02                 stz   <case_bits               ;init to all upper case
1163 2393 AD 1A 30              lda   |blkbuf+casebits         ;get upper/lower case info for volume name
1164 2396 10 03                 bpl   cont                     ;it's not valid
1165 2398 0A                    asl   a                        ;it's valid, so get rid of the ON/OFF bit
1166 2399 85 02                 sta   <case_bits               ;and save the case bits
1167 239B              cont      
1168 239B AD 04 30              lda   |blkbuf+namelen          ;get length of volume name
1169 239E 29 0F 00              and   #$000f                   ;strip off hi byte and type nibble
1170 23A1 85 26                 sta   <name_len                ;save for later
1171 23A3 1A                    inc   a                        ;add 1 for leading colon
1172 23A4 87 08                 sta   [<path_ptr]              ;store in output string as length word
1173 23A6
1174 23A6                       longa off
1175 23A6                       longi off
1176 23A6 E2 30                 sep   #$30                     ; ***** begin 8-bit mode *****
1177 23A8
1178 23A8 A2 00                 ldx   #0                       ;init index into volume name
1179 23AA A0 02                 ldy   #2                       ;init index into output string
1180 23AC A9 3A                 lda   #':'                     ;add a colon at start of output string
1181 23AE 97 08                 sta   [<path_ptr],y
1182 23B0
1183 23B0              loop      
1184 23B0 E8                    inx   
1185 23B1 C8                    iny   
1186 23B2
1187 23B2 BD 04 30              lda   |blkbuf+namelen,x        ;copy volume name into output string
1188 23B5 C2 20                 rep   #$20                     ;16-bit mode for the rotate
1189 23B7 26 02                 rol   <case_bits               ;should this char be upper or lower case?
1190 23B9 E2 20                 sep   #$20                     ;back to 8-bit mode
1191 23BB 90 02                 bcc   its_upper                ;leave it upper case
1192 23BD 09 20                 ora   #$20                     ;make the char lower case
1193 23BF              its_upper  
1194 23BF 97 08                 sta   [<path_ptr],y
1195 23C1 E4 26                 cpx   <name_len                ;done?
1196 23C3 D0 EB                 bne   loop                     ;no
1197 23C5
1198 23C5                       longa on
1199 23C5                       longi on
1200 23C5 C2 30                 rep   #$30                     ; ***** return to 16-bit mode *****
1201 23C7
1202 23C7 18                    clc                            ;indicate no error
1203 23C8
1204 23C8              done      
1205 23C8 48                    pha                            ;save error code if any
1206 23C9 A5 00                 lda   <save_d                  ;restore direct register
1207 23CB 5B                    tcd   
1208 23CC 68                    pla                            ;restore error code
1209 23CD 9C F2 22              stz   |cache1_num              ;zero out the cache info in case the
1210 23D0 9C F4 22              stz   |cache2_num              ;wrong disk is in the drive
1211 23D3 60                    rts   
1212 23D4                       ENDP 
1213 23D4
1214 23D4
1215 23D4
1216 23D4              ;===============================================================================
1217 23D4              ; getfstname
1218 23D4              ;
1219 23D4              ; Entry is in 16-bit native mode.
1220 23D4              ; Exit is in 16-bit native mode.
1221 23D4              ; Data bank register is preserved.
1222 23D4              ; Direct register is preserved.
1223 23D4              ;
1224 23D4              ; Inputs:       4 bytes - pointer to space for fst name
1225 23D4              ;
1226 23D4              ; Outputs:      none
1227 23D4              ;
1228 23D4              ; This routine will return the name of the start fst in class 1 format
1229 23D4              ; with no leading or trailing separators.
1230 23D4              ;=============================================================================
1231 23D4
1232 23D4                       EXPORT getfstname
1233 23D4              getfstname PROC 
1234 23D4
1235 23D4                       longa on
1236 23D4                       longi on
1237 23D4
1238 23D4              ;save current direct register and set it to point to our data area
1239 23D4
1240 23D4 7B                    tdc   
1241 23D5 F4 84 26              pea   dp_start
1242 23D8 2B                    pld   
1243 23D9 85 00                 sta   <save_d
1244 23DB
1245 23DB              ;pull inputs off stack
1246 23DB
1247 23DB FA                    plx                            ;pull return address off stack
1248 23DC 68                    pla                            ;pull pointer to string off stack
1249 23DD 85 08                 sta   <path_ptr                ;and save
1250 23DF 68                    pla   
1251 23E0 85 0A                 sta   <path_ptr+2
1252 23E2 DA                    phx                            ;push return address back on stack
1253 23E3
1254 23E3              ;save data bank register and set it to bank $00
1255 23E3
1256 23E3 8B                    phb   
1257 23E4 4B                    phk   
1258 23E5 AB                    plb   
1259 23E6
1260 23E6              ;copy start fst name into caller's area
1261 23E6
1262 23E6 AD E4 25              lda   |fst_name                ;get length of fst name
1263 23E9 1A                    inc   a                        ;add 1 for extra length byte
1264 23EA A8                    tay   
1265 23EB
1266 23EB                       longa off
1267 23EB                       longi off
1268 23EB E2 30                 sep   #$30                     ; ***** begin 8-bit mode *****
1269 23ED
1270 23ED B9 E4 25     loop     lda   |fst_name,y              ;copy fst name into output string
1271 23F0 97 08                 sta   [<path_ptr],y
1272 23F2 88                    dey   
1273 23F3 10 F8                 bpl   loop
1274 23F5
1275 23F5                       longa on
1276 23F5                       longi on
1277 23F5 C2 30                 rep   #$30                     ; ***** return to 16-bit mode *****
1278 23F7
1279 23F7              ; restore data bank register and direct register and return to caller
1280 23F7
1281 23F7 AB                    plb                            ;restore data bank register
1282 23F8 A5 00                 lda   <save_d                  ;restore direct register
1283 23FA 5B                    tcd   
1284 23FB 60                    rts   
1285 23FC                       ENDP 
1286 23FC
1287 23FC
1288 23FC
1289 23FC              ;===============================================================================
1290 23FC              ; startup
1291 23FC              ;
1292 23FC              ; Exit is in 16-bit native mode.
1293 23FC              ; Data bank register is set to bank $00 on exit.
1294 23FC              ; Direct register is set to $0000 on exit.
1295 23FC              ; Stack is set to $01ff on exit.
1296 23FC              ;
1297 23FC              ; This routine is called by the disk boot firmware.
1298 23FC              ; It first verifies that it is running on a //GS with the correct ROM and then
1299 23FC              ; it loads in /v/SYSTEM/START.GS.OS and transfers control to it.
1300 23FC              ;
1301 23FC              ; The aux type of the file START.GS.OS contains the boot time information
1302 23FC              ; used by the graphics splash screen. So, after START.GS.OS is read in, its
1303 23FC              ; aux type is stored at the end of the jump table.  Then, when we transfer
1304 23FC              ; control to START.GS.OS, GLoader will pick up the aux type value from the end
1305 23FC              ; of the jump table and pass it to the graphics splash screen routine.
1306 23FC              ;===============================================================================
1307 23FC
1308 23FC                       EXPORT startup
1309 23FC              startup  PROC 
1310 23FC
1311 23FC                       longa on
1312 23FC                       longi on
1313 23FC
1314 23FC              ; At onset, we don't know what machine we are being run on.
1315 23FC              ; If we are not being run on an Apple //GS we must hang with an error message.
1316 23FC
1317 23FC              ; The following code will run on both the 65816 and 6502 processors
1318 23FC              ; to ensure 8 bit processing.
1319 23FC
1320 23FC BA                    tsx                            ;save stack pointer.
1321 23FD A9 30 30              lda   #$3030
1322 2400 EA                    nop                            ;required filler.
1323 2401 48                    pha                            ;push $30 on stack.
1324 2402 28                    plp                            ;and retrieve for full 8 bit mode.
1325 2403
1326 2403                       longa off
1327 2403                       longi off
1328 2403
1329 2403 9A                    txs                            ;restore stack.
1330 2404
1331 2404              ; The above code looks like the following for a 6502...
1332 2404              ; (this code essentially does nothing on a 6502)
1333 2404
1334 2404              ; tsx
1335 2404              ; lda #$30
1336 2404              ; bmi nop ; will never be taken....
1337 2404              ; pha
1338 2404              ; plp
1339 2404              ; txs
1340 2404
1341 2404 AD 81 C0              lda   romin                    ;bank in rom.
1342 2407 38                    sec                            ;go into //GS id routine with c set
1343 2408 20 1F FE              jsr   idroutine                ;are we on a //GS?
1344 240B B0 5B                 bcs   to_showerrmsg            ;no
1345 240D C0 01                 cpy   #$01                     ;is rom revision 01 or greater?
1346 240F 90 57                 bcc   to_showerrmsg            ;no
1347 2411
1348 2411              ;We must be in emulation mode on a //GS (Fern said so, and if he is
1349 2411              ;wrong he must put in the stack futz for us).
1350 2411
1351 2411 F4 00 00              pea   $0000                    ;ensure zero page at $000000
1352 2414 2B                    pld   
1353 2415
1354 2415 4B                    phk                            ;set data bank to code bank
1355 2416 AB                    plb   
1356 2417
1357 2417              *** ROM Version is still in Y!
1358 2417
1359 2417              *** added 6-May-93 DAL/SS -- create a RAM disk on an 8 Meg ROM 3 machine, since
1360 2417              ***   the ROM accidentally decided we couldn't have one
1361 2417 C0 03                 cpy   #3
1362 2419 D0 03                 bne   @notROM3
1363 241B 20 B6 24              jsr   CreateRAM5
1364 241E              @notROM3  
1365 241E              *** end 6-May-93
1366 241E
1367 241E 20 47 25              jsr   id_sp                    ; setup readblock for proper interface
1368 2421
1369 2421 18                    clc   
1370 2422 FB                    xce                            ; ***** begin native mode *****
1371 2423 C2 30                 rep   #$30                     ; ***** begin 16-bit mode *****
1372 2425                       longa on
1373 2425                       longi on
1374 2425
1375 2425 A9 FF 01              lda   #$01ff                   ;set stack to $01ff
1376 2428 1B                    tcs   
1377 2429
1378 2429              *** added 27-Oct-92 DAL -- If they hit "8", run System/P8 instead of Start.GS.OS
1379 2429 AD 00 C0              lda   $C000
1380 242C 29 FF 00              and   #$00ff
1381 242F C9 B8 00              cmp   #$00b8                   ;'8'
1382 2432 F0 37                 beq   GoProDOS8
1383 2434              *** end 27-Oct-92
1384 2434
1385 2434              ;Now, read in the /v/SYSTEM/START.GS.OS file
1386 2434
1387 2434 48                    pha                            ;8 byte space for results
1388 2435 48                    pha   
1389 2436 48                    pha   
1390 2437 48                    pha   
1391 2438 F4 00 00              pea   start_path>>16           ;ptr to partial pathname
1392 243B F4 C5 25              pea   start_path
1393 243E F4 00 00              pea   0                        ;pointer to mem location for START.GS.OS
1394 2441 F4 00 68              pea   start_loc
1395 2444 20 0E 20              jsr   readinfile               ;find START.GS.OS and read it in
1396 2447 90 0E                 bcc   read_ok
1397 2449 48                    pha                            ;error #
1398 244A F4 00 00              pea   $0000
1399 244D F4 ED 25              pea   startup_err              ;address of error msg
1400 2450 A2 03 15     fatal    ldx   #$1503                   ;call sysfailmgr to report error
1401 2453 22 00 00 E1           jsl   $E10000                  ;doesn't return
1402 2457
1403 2457 68           read_ok  pla                            ;ignore filetype
1404 2458 68                    pla                            ;get auxtype
1405 2459 8D 0C 20              sta   |aux_value               ;and store at end of jump table
1406 245C 68                    pla                            ;ignore eof
1407 245D 68                    pla   
1408 245E
1409 245E 9C F2 22              stz   |cache1_num              ;zero out these two items so that
1410 2461 9C F4 22              stz   |cache2_num              ;caching is now active
1411 2464
1412 2464              ;Now, transfer control to START.GS.OS
1413 2464
1414 2464 5C 00 68 00           jmp   >start_loc
1415 2468
1416 2468 4C 06 25     to_showerrmsg jmp   showerrmsg
1417 246B
1418 246B              *** added 27-Oct-92 DAL
1419 246B 8D 10 C0     GoProDOS8 sta   $C010                   ;clear keyboard strobe (eat the "8")
1420 246E
1421 246E 48                    pha                            ;8 byte space for results
1422 246F 48                    pha   
1423 2470 48                    pha   
1424 2471 48                    pha   
1425 2472 F4 00 00              pea   start_p8_path>>16        ;ptr to partial pathname
1426 2475 F4 D9 25              pea   start_p8_path
1427 2478 F4 00 00              pea   0                        ;pointer to mem location for P8
1428 247B F4 00 68              pea   start_loc
1429 247E 20 0E 20              jsr   readinfile               ;find System/P8 and read it in
1430 2481 90 08                 bcc   read_p8_ok
1431 2483 48                    pha                            ;error #
1432 2484 A9 00 00              lda   #0
1433 2487 48                    pha   
1434 2488 48                    pha                            ;error message string
1435 2489 80 C5                 bra   fatal
1436 248B
1437 248B 68           read_p8_ok pla                          ;discard filetype
1438 248C 68                    pla                            ;discard auxtype
1439 248D 68                    pla                            ;low word of EOF
1440 248E 3A                    dec   a
1441 248F 8D A9 24              sta   p8_length+1
1442 2492 68                    pla                            ;discard EOF high word
1443 2493 A2 A2 24              ldx   #p8_jumper
1444 2496 A0 00 02              ldy   #$0200                   ;move code to $200
1445 2499 A9 14 00              lda   #p8_jump_end-p8_jumper
1446 249C 54 00 00              mvn   0,0
1447 249F 4C 00 02              jmp   $0200
1448 24A2
1449 24A2 A2 00 68     p8_jumper ldx   #start_loc
1450 24A5 A0 00 20              ldy   #$2000                   ;move P8 to $2000
1451 24A8 A9 77 77     p8_length lda   #$7777                  ;length of P8 (modified)
1452 24AB 54 00 00              mvn   0,0
1453 24AE 38                    sec   
1454 24AF FB                    xce   
1455 24B0                       longa off
1456 24B0                       longi off
1457 24B0 A2 FF                 ldx   #$FF
1458 24B2 9A                    txs   
1459 24B3 4C 00 20              jmp   $2000
1460 24B6              p8_jump_end  
1461 24B6
1462 24B6              *** end 27-Oct-92
1463 24B6
1464 24B6              *** 6-May-93 DAL/SS -- Create RAM5 if necessary (we already know we're on ROM 3)
1465 24B6 18           CreateRAM5 clc   
1466 24B7 FB                    xce   
1467 24B8 C2 30                 rep   #$30
1468 24BA                       longa on
1469 24BA                       longi on
1470 24BA
1471 24BA              NumBanks equ   $E11624                  ;Number of 64K banks in machine
1472 24BA              DiskHandle equ   $E11646
1473 24BA              MaxDiskParm equ   $E102F7               ;inside the Battery RAM buffer (max RAM5 size, N*32K)
1474 24BA
1475 24BA 8B                    phb   
1476 24BB F4 E1 E1              pea   $E1E1
1477 24BE AB                    plb   
1478 24BF AB                    plb   
1479 24C0
1480 24C0 AD 47 16              lda   |DiskHandle+1
1481 24C3 D0 3D                 bne   @noProblem               ;already have a RAM5 handle
1482 24C5
1483 24C5 AD F7 02              lda   |MaxDiskParm
1484 24C8 29 FF 00              and   #$00ff
1485 24CB F0 35                 beq   @noProblem
1486 24CD
1487 24CD AD 24 16              lda   |NumBanks
1488 24D0 C9 80 00              cmp   #$80
1489 24D3 90 2D                 bcc   @noProblem
1490 24D5
1491 24D5              *** make a stack frame
1492 24D5 0B                    phd   
1493 24D6 3B                    tsc   
1494 24D7 38                    sec   
1495 24D8 E9 20 00              sbc   #$0020
1496 24DB 1B                    tcs   
1497 24DC 1A                    inc   a
1498 24DD 5B                    tcd   
1499 24DE
1500 24DE 4B                    phk   
1501 24DF 62 09 00              per   @return-1
1502 24E2 F4 BB 00              pea   #$00BC-1
1503 24E5 A9 81 00              lda   #$81                     ;pretend like we have *almost* 8 megs, to make ROM check happy
1504 24E8 5C D1 14 FC           jmp   >$FC14D1                 ;jump into the middle of MakeDisk, right after TotalMem
1505 24EC 3B           @return  tsc   
1506 24ED 18                    clc   
1507 24EE 69 20 00              adc   #$0020
1508 24F1 1B                    tcs   
1509 24F2 2B                    pld   
1510 24F3
1511 24F3              *** now reboot if we created a new RAM5
1512 24F3 AD 47 16              lda   |DiskHandle+1
1513 24F6 F0 0A                 beq   @noProblem               ;failed to create one
1514 24F8
1515 24F8 AB                    plb                            ;restore B to $00
1516 24F9 9C F3 03              stz   $03f3                    ;trash $3f3 and $3f4
1517 24FC 38                    sec   
1518 24FD FB                    xce   
1519 24FE                       longa off
1520 24FE                       longi off
1521 24FE 78                    sei   
1522 24FF 4C 62 FA              jmp   $fa62                    ;Reset!
1523 2502
1524 2502 AB           @noProblem plb   
1525 2503
1526 2503 38                    sec   
1527 2504 FB                    xce   
1528 2505                       longa off
1529 2505                       longi off
1530 2505
1531 2505 60                    rts   
1532 2506
1533 2506              *** end 6-May-93
1534 2506
1535 2506              ;-------------------------------------------------------------------------------
1536 2506
1537 2506              showerrmsg   
1538 2506                       longa off
1539 2506                       longi off
1540 2506
1541 2506              ; enter this routine with 'c'=1 for wrong system error
1542 2506              ; enter this routine with 'c'=0 for wrong rom in system
1543 2506
1544 2506 08                    php                            ;save 'c' around setup stuff
1545 2507 AD 81 C0              lda   romin                    ; rom in for monitor's home routine.
1546 250A 8D 0C C0              sta   clr80vid                 ; disable 80 column hardware.
1547 250D 8D 0E C0              sta   clraltchar               ; switch in primary char set.
1548 2510 8D 00 C0              sta   clr80col                 ; disable 80 column store.
1549 2513 20 2F FB              jsr   init                     ; text pg1; text mode; set 40 col window
1550 2516 20 93 FE              jsr   setvid                   ; does a 'pr#0'(puts in cout1 in csw)
1551 2519 20 84 FE              jsr   setnorm                  ; normal white chars on black backround
1552 251C 20 58 FC              jsr   home                     ; clear screen
1553 251F 28                    plp                            ;well, which message gets shown
1554 2520
1555 2520 AC 16 26              ldy   not_a_gs                 ; get length of message
1556 2523 B0 03                 bcs   printerr
1557 2525 AC 3A 26              ldy   wrong_rom                ; get length of message
1558 2528
1559 2528              printerr  
1560 2528 B9 16 26              lda   not_a_gs,y
1561 252B B0 03                 bcs   printerr2
1562 252D B9 3A 26              lda   wrong_rom,y
1563 2530
1564 2530              printerr2  
1565 2530 99 A8 05              sta   screen,y                 ; store directly to screen
1566 2533 88                    dey   
1567 2534 D0 F2                 bne   printerr
1568 2536 B0 0C                 bcs   hang                     ; if 'wrong system' msg, we're done
1569 2538
1570 2538 AC 61 26              ldy   wrong_rom2               ; now put up second line of
1571 253B              nextline                                ; the 'wrong rom' msg
1572 253B B9 61 26              lda   wrong_rom2,y
1573 253E 99 A8 06              sta   screen2,y                ; store directly to screen
1574 2541 88                    dey   
1575 2542 D0 F7                 bne   nextline
1576 2544
1577 2544 4C 44 25     hang     jmp   hang                     ; just hang'n around.
1578 2547
1579 2547
1580 2547                       eject 
1581 2547              ;-------------------------------------------------------------------------------
1582 2547              ;
1583 2547              ; Identify if SmartPort interface exists on startup.
1584 2547              ;
1585 2547              ; ENTRY: via a 'JSR'
1586 2547              ;               $0043 = ProDOS unit number
1587 2547              ;               $07F8 = $Cn
1588 2547              ;               A Reg = Unknown
1589 2547              ;               X Reg = Unknown
1590 2547              ;               Y Reg = Unknown
1591 2547              ;            Bank Reg = $00
1592 2547              ;             Dir Reg = $0000
1593 2547              ;               P Reg = N V M X D I Z C   E
1594 2547              ;                       x x 1 1 0 x x x   1
1595 2547              ;
1596 2547              ; EXIT: via a 'RTS'
1597 2547              ;               A Reg = Unknown
1598 2547              ;               X Reg = Unknown
1599 2547              ;               Y Reg = Unknown
1600 2547              ;            Bank Reg = $00
1601 2547              ;             Dir Reg = $0000
1602 2547              ;               P Reg = N V M X D I Z C   E
1603 2547              ;                       x x 1 1 0 x x x   1
1604 2547              ;
1605 2547              ;-------------------------------------------------------------------------------
1606 2547
1607 2547              id_sp     
1608 2547                       longa off
1609 2547                       longi off
1610 2547
1611 2547 AD F8 07              lda   |mslot
1612 254A 09 C0                 ora   #$C0                     ; create $Cn00 for (card),y addressing
1613 254C 85 45                 sta   <devbuf+1
1614 254E 8D D3 22              sta   |godev+2
1615 2551 8D ED 22              sta   |slot_num+1              ; save for read_block routine
1616 2554 64 44                 stz   <devbuf
1617 2556 20 95 25              jsr   get_pro_entry            ; determine prodos entry point
1618 2559 8D D2 22              sta   |godev+1                 ; set $CnXX (ProDOS entry point)
1619 255C A0 07                 ldy   #$07                     ; $Cn07 = $00 if SmartPort interface
1620 255E B1 44                 lda   (<devbuf),y
1621 2560 D0 32                 bne   not_sp
1622 2562 A0 FB                 ldy   #$FB                     ; $CnFB bit 7 set if extended SmartPort
1623 2564 B1 44                 lda   (<devbuf),y
1624 2566 10 2C                 bpl   not_sp
1625 2568
1626 2568              ; Host interface supports extended SmartPort calls.  Now need to know
1627 2568              ; if the device supports extended SmartPort calls.
1628 2568
1629 2568 20 95 25              jsr   get_pro_entry            ; need $Cn00 + ($CnFF)
1630 256B 69 03                 adc   #$03                     ; SmartPort = $Cn00 + ($CnFF) + 3
1631 256D 8D 79 25              sta   sp_stat+1
1632 2570 A5 45                 lda   <devbuf+1
1633 2572 8D D3 22              sta   |godev+2
1634 2575 8D 7A 25              sta   sp_stat+2
1635 2578
1636 2578              sp_stat   
1637 2578 20 0D C7              jsr   $C000                    ; call SmartPort
1638 257B 00                    DC B:0                         ; command = status call
1639 257C 9B 25                 DC W:s_plist                   ; param list pointer
1640 257E
1641 257E              sp_ret    
1642 257E AD B6 25              lda   |sp_subtype              ; is device extended?
1643 2581 10 11                 bpl   not_sp                   ; no
1644 2583
1645 2583              ; Device and host are extended.  Set up the readblock call
1646 2583              ; to use a SmartPort call structure.  The parameter in SP_SUBTYPE
1647 2583              ; indicates whether read should use the ProDOS or SmartPort interface.
1648 2583              ; Bit 7 = 0 if ProDOS should be used.
1649 2583
1650 2583 AD 79 25              lda   |sp_stat+1               ; point at SmartPort entry
1651 2586 8D D2 22              sta   |godev+1
1652 2589 A2 04                 ldx   #$04
1653 258B              sp_setup_loop  
1654 258B BD C0 25              lda   |call_data,x
1655 258E 9D D4 22              sta   |godev+3,x
1656 2591 CA                    dex   
1657 2592 10 F7                 bpl   sp_setup_loop
1658 2594              not_sp    
1659 2594 60                    rts   
1660 2595
1661 2595              ; <devbuf must contain $Cn00 on entry to this routine.
1662 2595
1663 2595              get_pro_entry  
1664 2595 A0 FF                 ldy   #$FF                     ; SP entry = $Cn00 + ($CnFF) + 3
1665 2597 18                    clc   
1666 2598 B1 44                 lda   (<devbuf),y
1667 259A 60                    rts   
1668 259B
1669 259B 03           s_plist  DC B:3                         ; parameter count
1670 259C 01                    DC B:1                         ; unit
1671 259D A0 25                 DC W:s_list                    ; pointer to status list
1672 259F 03                    DC B:3                         ; DIB status call
1673 25A0
1674 25A0 F8           s_list   DC B:0                         ; status byte
1675 25A1 FF FF                 DC W:0                         ; low word block count
1676 25A3 00                    DC B:0                         ; high block count
1677 25A4 02                    DC B:0                         ; id string length
1678 25A5 58                    DC B:$20                       ; id string
1679 25A6 52                    DC B:$20
1680 25A7 20                    DC B:$20
1681 25A8 20                    DC B:$20
1682 25A9 20                    DC B:$20
1683 25AA 20                    DC B:$20
1684 25AB 20                    DC B:$20
1685 25AC 20                    DC B:$20
1686 25AD 20                    DC B:$20
1687 25AE 20                    DC B:$20
1688 25AF 20                    DC B:$20
1689 25B0 20                    DC B:$20
1690 25B1 20                    DC B:$20
1691 25B2 20                    DC B:$20
1692 25B3 20                    DC B:$20
1693 25B4 20                    DC B:$20
1694 25B5 02           sp_type  DC B:0                         ; type
1695 25B6 A0           sp_subtype DC B:0                       ; subtype
1696 25B7 01 00        sp_version DC W:0                       ; version number
1697 25B9 00 00 00 00           DS B:7                         ; added 2/1/89 CAE for 3rd party devices
1698 25C0
1699 25C0 41           call_data DC B:$41                      ; extended read call
1700 25C1 E2 22 00 00           DC L:read_plist                ; parameter list pointer
1701 25C5
1702 25C5                       ENDP 
1703 25C5
1704 25C5              ;===============================================================================
1705 25C5              ;
1706 25C5              ; pb_data
1707 25C5              ;
1708 25C5              ;===============================================================================
1709 25C5
1710 25C5                       EXPORT pb_data
1711 25C5              pb_data  PROC 
1712 25C5
1713 25C5              ;-------------------------------------------------------------------------------
1714 25C5              ; strings
1715 25C5              ;-------------------------------------------------------------------------------
1716 25C5
1717 25C5                       EXPORT start_path
1718 25C5 12 00        start_path DC W:18                      ;class 1 string
1719 25C7 53 59 53 54           DC B:'SYSTEM:START.GS.OS'
1720 25D9
1721 25D9              *** added 27-Oct-92 DAL
1722 25D9                       EXPORT start_p8_path
1723 25D9 09 00        start_p8_path DC W:9                    ;class 1 string
1724 25DB 53 59 53 54           DC B:'SYSTEM:P8'
1725 25E4              *** end 27-Oct-92
1726 25E4
1727 25E4                       EXPORT fst_name
1728 25E4 07 00        fst_name DC W:7                         ;class 1 string
1729 25E6 50 52 4F 2E           DC B:'PRO.FST'
1730 25ED
1731 25ED                       EXPORT startup_err
1732 25ED 28           startup_err DC B:40
1733 25EE 55 6E 61 62           DC B:'Unable to load START.GS.OS file. Error=$'
1734 2616
1735 2616                       msb   on
1736 2616
1737 2616                       EXPORT not_a_gs
1738 2616 23           not_a_gs DC B:35
1739 2617 C7 D3 AF CF           DC B:'GS/OS REQUIRES APPLE IIGS HARDWARE '
1740 263A
1741 263A                       EXPORT wrong_rom
1742 263A 26           wrong_rom DC B:38
1743 263B C7 D3 AF CF           DC B:'GS/OS needs ROM version 01 or greater.'
1744 2661                       EXPORT wrong_rom2
1745 2661 22           wrong_rom2 DC B:34
1746 2662 D3 E5 E5 A0           DC B:'See your dealer for a ROM upgrade.'
1747 2684
1748 2684
1749 2684              ;-------------------------------------------------------------------------------
1750 2684              ; Direct Page Start Address
1751 2684              ; NOTE - no code or data can follow this label or it will be overwritten
1752 2684              ;-------------------------------------------------------------------------------
1753 2684
1754 2684                       EXPORT dp_start
1755 2684              dp_start  
1756 2684
1757 2684                       ENDP 
1758 2684
1759 2684                       END   
